/*******************************************************************************
********************************************************************************
** COPYRIGHT:    (c) 2013 Rohde & Schwarz
** MODULE:       CSCPIFileAccess_PR100.h
** LANGUAGE:     C/C++
** AUTHOR:       
** ABSTRACT:     Example to access files in a PR100
** PREMISES:
** REMARKS:
** HISTORY:
********************************************************************************/
#ifndef CSCPI_FILEACCESS_H
#define CSCPI_FILEACCESS_H

/* INCLUDE FILES ***************************************************************/
#include "CSCPIHelper_PR100.h"
#include <vector>

/* CLASSES ***************************************************************/

class CSCPIFileAccess
{
public:
    struct FILE_PROPERTY
    {
        //File specific property
        std::string path; //path of file
        std::string name; //filename (w/o extension)
        std::string ext;  //file extension
        int         size; //filesize in bytes
        std::string date; //date in yyyy/mm/dd format
        std::string time; //time in hh:mm:ss format

        //Device info
        std::string devAddress; //ip address or hostname of device
        std::string devName   ; //name of device
        int         devSN     ; //serial number of device
    };


public:
    //Constructor
    CSCPIFileAccess(CSCPIHelper& device, CSCPIHelper::CallbackFunc callback, void * pPrivate);

    //Get the list of files in the specified directory.
	//Results are appended to the "result" vector.
    // The default device directories on a device is "\Storage Card\<devicename>"
    //Returns 
    // 0 = no error
    // otherwise = SCPI error code.
    int listfiles(const std::string& path, std::vector<CSCPIFileAccess::FILE_PROPERTY>& result);

    //Download the remotefile (absolute or relative path) from the device.
    // The data will be passed to the callback function registered in the constructor.
    //Returns 
    //  0 = no error
    // -1 = timeout receiving data
    // -2 = corrupted data received
    // otherwise = SCPI error code.
    int download(const std::string& remotefile);

    //Debug functions
    void  SetDebugLevel(bool bEnable) {m_bDebugOutput = bEnable;}


protected:

    //Constants
    static const int READ_TIMEOUT_MS        = 2000;
    static const int READ_BUFFER_SIZE_BYTES = 1500;

    //Member variables
    CSCPIHelper&                m_device;
    CSCPIHelper::CallbackFunc   m_callBackFunc;
    void                      * m_pCallbackPrivate;

    bool                        m_bDebugOutput;

};

#endif